"use strict";
exports.id = 848;
exports.ids = [848];
exports.modules = {

/***/ 5848:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "C$": () => (/* binding */ cartReducer),
/* harmony export */   "M$": () => (/* binding */ setQuantity),
/* harmony export */   "UY": () => (/* binding */ emptyCart),
/* harmony export */   "Xq": () => (/* binding */ addToCart),
/* harmony export */   "cl": () => (/* binding */ removeItem)
/* harmony export */ });
/* unused harmony exports incrementQuantity, decrementQuantity */
/* harmony import */ var _reduxjs_toolkit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5184);
/* harmony import */ var _reduxjs_toolkit__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_reduxjs_toolkit__WEBPACK_IMPORTED_MODULE_0__);

const axios = __webpack_require__(2167);
const API_URL = "https://qrs-global.com/react/general/index.php";
// create a slice
const cartSlice = (0,_reduxjs_toolkit__WEBPACK_IMPORTED_MODULE_0__.createSlice)({
    name: "cart",
    initialState: {
        cart: []
    },
    reducers: {
        addToCart: (state, action)=>{
            const itemInCart = state.cart.find((item)=>item.id === action.payload.id);
            if (itemInCart) {
                // itemInCart.qty++;
                itemInCart.qty = itemInCart.qty + action.payload.qty;
            } else {
                // state.cart.push({ ...action.payload, qty: 1 });
                state.cart.push(action.payload);
            }
        },
        incrementQuantity: (state, action)=>{
            const item = state.cart.find((item)=>item.id === action.payload);
            item.qty++;
        },
        decrementQuantity: (state, action)=>{
            const item = state.cart.find((item)=>item.id === action.payload);
            if (item.qty === 1) {
                item.qty = 1;
            } else {
                item.qty--;
            }
        },
        setQuantity: (state, action)=>{
            const item = state.cart.find((item)=>item.id === action.payload.id);
            item.qty = action.payload.qty;
        },
        removeItem: (state, action)=>{
            const removeItem = state.cart.filter((item)=>item.id !== action.payload);
            state.cart = removeItem;
        },
        emptyCart: (state, action)=>{
            state.cart = [];
        }
    }
});
const cartReducer = cartSlice.reducer;
const { addToCart , incrementQuantity , decrementQuantity , setQuantity , removeItem , emptyCart ,  } = cartSlice.actions;


/***/ })

};
;