import mongoose from 'mongoose';
const tourSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: [true, 'A tour must have a name'],
      unique: true,
      trim: true,
      maxlength: [40, 'A tour name must have less or equal then 40 characters'],
      minlength: [10, 'A tour name must have more or equal then 10 characters'],
      // validate: [validator.isAlpha, 'Name must have letters only!'],
    },
  },
  {
    toJSON: { virtuals: true },
    toObject: { virtuals: true },
  }
);

//   // tourSchema.index({ price: 1 });
//   tourSchema.index({ price: 1, ratingsAverage: -1 });
//   tourSchema.index({ slug: 1 });
//   tourSchema.index({ startLocation: '2dsphere' });

//   tourSchema.virtual('durationWeeks').get(function () {
//     return this.duration / 7;
//   });
//   //Virutal populate
//   tourSchema.virtual('reviews', {
//     ref: 'Review',
//     foreignField: 'tour',
//     localField: '_id',
//   });
//   //DOCUMENT MIDDLE WARE: uns before the .save() and .create()
//   tourSchema.pre('save', function (next) {
//     // console.log(this);
//     this.slug = slugify(this.name, { lower: true });
//     next();
//   });

//   // tourSchema.pre('save', async function (next) {
//   //   const guidesPromises = this.guides.map(async (id) => await User.findById(id));
//   //   this.guides = await Promise.all(guidesPromises);
//   //   next();
//   // });
//   // tourSchema.post('save', function (doc, next) {
//   //   console.log(doc);
//   //   next();
//   // });

//   //QUERY MIDDLEWARE
//   // tourSchema.pre('find', function (next) {
//   tourSchema.pre(/^find/, function (next) {
//     this.find({ secretTour: { $ne: true } });
//     this.start = Date.now();
//     next();
//   });

//   tourSchema.pre(/^find/, function (next) {
//     this.populate({
//       path: 'guides',
//       select: '-__v -passwordChangedAt',
//     });
//     next();
//   });

//   tourSchema.post(/^find/, function (docs, next) {
//     console.log(`Query took ${Date.now() - this.start} ms`);
//     // console.log(docs);
//     next();
//   });

//   //AGGREGATION MIDDLE WARE

//   // tourSchema.pre('aggregate', function (next) {
//   //   this.pipeline().unshift({ $match: { secretTour: { $ne: true } } });
//   //   console.log(this.pipeline());
//   //   next();
//   // });

const Tour = mongoose.models.Samar || mongoose.model('Samar', tourSchema);

module.exports = Tour;
